/**
 * \file: scan_dirs_other.c
 */
/*PRQA: QAC Message 288: invalid chars are always in file header */
/* \version: $Id: scan_dirs_other.c,v 1.4 2010/06/29 08:18:55 dlangner Exp $
 *
 * \component:  helper functions for svg_font library to scan for font file within directory
 *
 * \author:
 *
 * \copyright: (c) 2003 - 2006 ADIT Corporation
 *
 * \history
 *
 ***********************************************************************/

#include "grl_font.h"
#include "svg_font_err.h"
#include "svg_error.h"
#include "grl_configuration.h"
#include "grl_os_abstraction.h"
#include <dirent.h>

#ifdef COMPONENT_TEST
SVGChar svgPathNames[SVG_MAXPATH][256] = { "/host/fonts/" };
#else
                /**< for component test work with host file system.           */
SVGChar svgPathNames[SVG_MAXPATH][256] = { "/mnt/" };
                /**< Supports the USB device.                                 */
#endif

extern int  strcasecmp (const char *, const char *);


SVGError grl_font_scan_dir(SVGUint32       *p_nameList,
                           SVGUint32       *p_fileCount,
                           const SVGChar   *p_suffix_list ,
                           SVGChar*        svgpathname,
                           SVGUint32       *p_listCount )
{
    SVGError          err              = SVG_NO_ERROR;
    DIR               *p_ses           = NULL;
    struct dirent     *p_dir           = NULL;
    SVGUint32         j                = 0;
    SVGChar           *p_fileName      = NULL;
    SVGChar           searchBuf[5]     = {0};
    SVGChar           suffixBuf[5]     = {0};
    SVGUint32         fileCount        = 0;
    SVGUint32         listCount        = *p_listCount;
    /* PRQA: 311: pointers are checked */
/*PRQA S 311 L1 */
    SVGUint32         suffix_length    = strlen((const SVGChar*)p_suffix_list) / SUFFIX_LENGTH;
/*PRQA L L1 */

/* PRQA: 311: pointers are checked */
/*PRQA S 311  L1 */
    p_ses = opendir ( (SVGChar*)svgpathname );
/*PRQA L  L1 */

    if (p_ses == NULL)
    {
        err = SVG_FILE_IO_ERROR;
    }
    else
    {
        p_dir = readdir (p_ses);

        if (p_dir == NULL)
        {
            if (closedir(p_ses) == -1)
            {
            	SVG_FNT_W("CLOSE_PATH_ERROR IN LOCAL_BUILD_FILE_FONT_LIST");
            }
        }
        else
        {
            do
            {
                strncpy(suffixBuf,
                    (const SVGChar*)&p_dir->d_name[strlen(p_dir->d_name)-FF_INTEGER_LEN],
                    FF_INTEGER_LEN);

                for ( j = 0; j < suffix_length; j++ )
                {
/* PRQA: 311:   pointers are checked */
/*PRQA S 311 L1 */
                    strncpy(searchBuf,
                        (const SVGChar*)&p_suffix_list[j * SUFFIX_LENGTH],
                        FF_INTEGER_LEN);
/*PRQA L L1 */

                    if ( strcasecmp( (const SVGChar*)suffixBuf, (const SVGChar*)searchBuf ) == 0 )
                    {
                        /* found one more entry */
                        fileCount ++;

                        if (NULL != p_nameList)
                        {
                            /* allocate file name */
                            p_fileName = (SVGChar*)GRL_malloc_1D_resource(SVG_MAX_PATH * sizeof(SVGInt8));
                            if (NULL != p_fileName)
                            {
/* PRQA: 311:   pointers are checked */
/*PRQA S 311 L1 */
                                p_fileName = strncpy(p_fileName, svgpathname, SVG_MAX_PATH);
/*PRQA L L1 */
                                p_fileName = strncat(p_fileName,
                                    (const SVGChar*)p_dir->d_name,
                                    SVG_MAX_PATH - strlen((const SVGChar*)p_fileName));
/* PRQA: 306:   pointers are checked */
/*PRQA S 306 L1 */
                                p_nameList[listCount] = (uintptr_t)p_fileName;
/*PRQA L L1 */
                                listCount++;
                            }
                            else
                            {
                                err = SVG_FALSE;
                            }
                        }
                    }
                }
                p_dir = readdir (p_ses);
            } while ((p_dir != NULL) && (err == SVG_NO_ERROR));

            if (closedir(p_ses) == -1)
            {
            	SVG_FNT_W("CLOSE_PATH_ERROR IN LOCAL_BUILD_FILE_FONT_LIST");
            }
        }
    }
    if(NULL != p_fileCount)
    {
        *p_fileCount = fileCount;
    }

    if(NULL != p_listCount)
    {
        *p_listCount = listCount;
    }
    return err;
}
